<?php 
$element_content = !empty($contact_box_6_element_content) ? $contact_box_6_element_content : 'content-inner';

$zoom = 15;
$api_key = esc_html( get_option( 'elementor_google_maps_api_key' ) );
$params = [
	rawurlencode( $address ),
	absint( $zoom ),
];
if ( $api_key ) {
	$params[] = $api_key;

	$url = 'https://www.google.com/maps/embed/v1/place?key=%3$s&q=%1$s&amp;zoom=%2$d';
} else {
	$url = 'https://maps.google.com/maps?q=%1$s&amp;t=m&amp;z=%2$d&amp;output=embed&amp;iwloc=near';
}

$items = $contact_box_6_element_item;

?>
	
<section class="<?php echo esc_attr($element_content); ?>">
	<div class="container">
		<div class="row content-wrapper">
			<div class="col-xl-7 m-b30">
				<div class="map-wrapper style-3 me-xl-4">
					<?php if(!empty($address)){ ?>
					<iframe loading="lazy"
							src="<?php echo esc_url( vsprintf( $url, $params ) ); ?>"
							title="<?php echo esc_attr( $address ); ?>"
							aria-label="<?php echo esc_attr( $address ); ?>"
					></iframe>	
					<?php } ?>
					<div class="item1 position-absolute">
						<div class="content-bx style-5 alert alert-dismissible fade show" role="alert">
							<div class="content-logo">
								<?php do_action( 'clinicmaster_get_logo','site_logo'); ?>
							</div>
							<?php if(!empty($contact_box_6_element_contact_address_text) || !empty($contact_box_5_element_contact_address)){ ?>
								<div class="content-text m-b20">
									<?php if(!empty($contact_box_6_element_contact_address_text)){ ?>
									<h6 class="m-b5"><?php echo esc_html($contact_box_6_element_contact_address_text); ?> </h6>
								<?php }
								if(!empty($contact_box_6_element_contact_address)){ ?>
									<p class="m-b0"><?php echo esc_html($contact_box_6_element_contact_address); ?></p>
								<?php } ?>
								</div>
							<?php } ?>
							<?php if(!empty($contact_box_6_element_contact_hours_text) || !empty($contact_box_6_element_contact_hours)){ ?>
							<div class="content-text">
								<?php if(!empty($contact_box_6_element_contact_hours_text)){ ?>
									<h6 class="m-b5"><?php echo esc_html($contact_box_6_element_contact_hours_text); ?> </h6>
								<?php }
								if(!empty($contact_box_6_element_contact_hours)){ ?>
									<p class="m-b0"><?php echo wp_kses($contact_box_6_element_contact_hours, clinicmaster_allowed_html_tag()); ?></p>
								<?php } ?>
							</div>
							<?php } ?>
							<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
								<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M22.5 7.5L7.5 22.5" stroke="#AFAAA4" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
									<path d="M7.5 7.5L22.5 22.5" stroke="#AFAAA4" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
								</svg>
							</button>
						</div>
					</div>
				</div>
			</div>
			<div class="col-xl-5">
				<?php if(!empty($contact_box_6_element_title) || !empty($contact_box_6_element_description)){ ?>
				<div class="section-head style-1 m-b30">
					<?php if(!empty($contact_box_6_element_title)){ ?>
						<h2 class="title m-b5"><?php echo esc_html($contact_box_6_element_title); ?></h2>
					<?php } ?>
					<?php if(!empty($contact_box_6_element_description)){ ?>
						<p><?php echo wp_kses($contact_box_6_element_description,'string'); ?></p>
					<?php } ?>
				</div>
				<?php } ?>
				<div class="row">
					<?php if(!empty($items)){ 
					foreach($items as $val){
						$title = $val['contact_box_6_element_item_title'];
						$map_img = $val['contact_box_6_element_item_map_img'];
						$country_flag = $val['contact_box_6_element_item_country_flag'];
						$phone_num = $val['contact_box_6_element_item_phone_num'];
						$address = $val['contact_box_6_element_item_address'];
						$link_text = $val['contact_box_6_element_item_link_text'];
						$link = $val['contact_box_6_element_item_link'];

						?>
					<div class="col-xl-12 col-lg-6 m-b15"> 
						<div class="dz-img-box style-2">
							<div class="dz-content">	
								<div class="inner-content clearfix">
									<?php if(!empty($title)){ ?>
										<h3 class="title m-b10"><?php if(!empty($country_flag['id'])){ echo wp_get_attachment_image( $country_flag['id'], 'thumbnail' ); }  echo esc_html($title); ?></h3>
									<?php } ?>
									<?php if(!empty($address)){ ?>
										<p class="m-b10"><?php echo esc_html($address); ?></p>
									<?php }
									if(!empty($phone_num)){ ?>
										<a href="tel:<?php echo esc_url($phone_num); ?>" class="text-body"><?php echo esc_html($phone_num); ?></a> 
									<?php } ?>
								</div>
								<?php if(!empty($link_text) && !empty($link)){ ?>
									<div class="dz-footer">
										<a href="<?php echo esc_url($link); ?>" target="_blank" class="icon-link-hover-end"><?php echo esc_html($link_text); ?> <i class="feather icon-arrow-up-right"></i></a>
									</div>
								<?php } ?>
							</div>
							<?php 
							if(!empty($map_img['id'])){	?>
							<div class="dz-media">
								<?php echo wp_get_attachment_image( $map_img['id'], 'medium' ); ?>
							</div>
							<?php }  ?>
						</div>
					</div>
					<?php } 
					} ?>
				</div>
				
			</div>
		</div>
	</div>
</section>