<?php
$clinicmaster_option = getDZThemeReduxOption();
$general_phone_icon 	= !empty($clinicmaster_option['general_phone_icon']) ? $clinicmaster_option['general_phone_icon']: '';
$general_phone_text     = !empty($clinicmaster_option['general_phone_text']) ? $clinicmaster_option['general_phone_text']: '';
$general_phone_number   = !empty($clinicmaster_option['general_phone_number']) ? $clinicmaster_option['general_phone_number']:''; 
$style = !empty($appointment_element_style) ? $appointment_element_style : 'style_1';
$bg_img = $appointment_element_bg_img;
$img = $appointment_element_img;
$css_class = !empty($appointment_element_css_class) ? $appointment_element_css_class : '';

if($style == 'style_1'){ ?>

<section class="clearfix">
	<div class="container">
		<div class="row content-wrapper style-16" <?php if($bg_img['id']){ ?> style="background-image: url(<?php echo esc_url($bg_img['url']); ?>);" <?php } ?>>
			<div class="col-xl-6 col-md-7 col-sm-9">
				<div class="section-head style-3 position-relative mb-0 z-2">
					<?php if(!empty($appointment_element_title)){ ?>
						<h2 class="title m-b30"><?php echo esc_html($appointment_element_title); ?></h2>
					<?php }
					if(!empty($appointment_element_button_text) && !empty($appointment_element_button_link)){ ?>
					<a href="<?php echo esc_url($appointment_element_button_link); ?>" class="btn btn-lg btn-primary btn-rounded btn-hover2 btn-shadow">
						<?php echo esc_html($appointment_element_button_text); ?>
						<span class="right-icon"><i class="feather icon-arrow-right"></i></span>
					</a>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</section>
<?php }elseif($style == 'style_2'){ ?>
<section class="content-inner-1 <?php echo esc_attr($css_class); ?>">
	<div class="container">
		<div class="content-bx style-10 row g-0">
			<?php if(!empty($img['id'])){ ?>
			<div class="col-md-6">
				<div class="dz-media">
					<img src="<?php echo esc_url($img['url']); ?>" alt="<?php echo esc_attr('Image','clinicmaster'); ?>">
				</div>
			</div>
			<?php } ?>
			<div class="col-md-6">
				<?php if(!empty($appointment_element_title)){ ?>
					<h2 class="title"><?php echo esc_html($appointment_element_title); ?></h2>
					<?php }
					if(!empty($appointment_element_button_text) && !empty($appointment_element_button_link)){ ?>
					<a href="<?php echo esc_url($appointment_element_button_link); ?>" class="btn btn-lg btn-icon btn-primary btn-shadow">
						<span class="w-100"><?php echo esc_html($appointment_element_button_text); ?></span> <span class="right-icon"><i class="feather icon-arrow-right"></i></span>
					</a>
				<?php } ?>
			</div>
		</div>
	</div>
</section>

<?php }elseif($style == 'style_3'){ ?>
<section class="content-wrapper style-20 clearfix" <?php if($bg_img['id']){ ?> style="background-image: url(<?php echo esc_url($bg_img['url']); ?>);" <?php } ?>>
	<div class="container">
		<div class="row align-items-center h-100">
			<div class="col-md-6">
				<div class="section-head style-3 position-relative mb-0 z-2">
					<?php if(!empty($appointment_element_title)){ ?>
					<h2 class="title m-b40 fw-semibold"><?php echo esc_html($appointment_element_title); ?></h2>
					<?php }
					if(!empty($appointment_element_button_text) && !empty($appointment_element_button_link)){ ?>
					<a href="<?php echo esc_url($appointment_element_button_link); ?>" class="btn btn-lg btn-primary btn-rounded btn-hover2 btn-shadow">
						<?php echo esc_html($appointment_element_button_text); ?>
						<span class="right-icon"><i class="feather icon-arrow-right"></i></span>
					</a>
					<?php } ?>
				</div>
			</div>
			<div class="col-md-6 align-self-end">
				<?php if(!empty($img['id'])){ ?>
					<div class="dz-media">
						<img src="<?php echo esc_url($img['url']); ?>" alt="<?php echo esc_attr('Image','clinicmaster'); ?>">
						<?php if(!empty($appointment_element_item_img['id'])){ ?>
						<div class="item1">
							<img class="move-2" src="<?php echo esc_url($appointment_element_item_img['url']); ?>" alt="<?php echo esc_attr('Image','clinicmaster'); ?>">
						</div>
						<?php } ?>
					</div>
					<?php if(!empty($appointment_element_item_img2['id'])){ ?>
						<div class="item2">
							<img class="move-1" src="<?php echo esc_url($appointment_element_item_img2['url']); ?>" alt="<?php echo esc_attr('Image','clinicmaster'); ?>">
						</div>
					<?php } ?>
				<?php } ?>
			</div>
		</div>
	</div>
</section>
<?php }elseif($style == 'style_4'){ ?>
<div class="dz-bnr-inr style-1 detail-bx overlay-secondary-dark dz-bnr-inr-md"  <?php if($bg_img['id']){ ?> style="background-image: url(<?php echo esc_url($bg_img['url']); ?>);" <?php } ?>>
	<div class="container">
		<div class="dz-bnr-inr-entry row">
			<div class="col-xl-6 col-lg-7">
				<div class="dz-bnr-bx">
					<?php if(!empty($appointment_element_title)){ ?>
						<h1><?php echo esc_html($appointment_element_title); ?></h1>
					<?php }
					if(!empty($appointment_element_description)){ ?>
					<p><?php echo wp_kses($appointment_element_description, 'string'); ?></p>
					<?php } ?>
					<div class="d-flex flex-wrap align-items-center bottom-info">
					<?php
						if(!empty($appointment_element_button_text) && !empty($appointment_element_button_link)){ ?>
						<a href="<?php echo esc_url($appointment_element_button_link); ?>" class="btn btn-lg btn-icon btn-primary btn-shadow m-r30 mb-3 mb-sm-0">
							<?php echo esc_html($appointment_element_button_text); ?><span class="right-icon"><i class="feather icon-arrow-right"></i></span>
						</a>
						<?php }
						if(!empty($appointment_element_contact_us) && ($appointment_element_contact_us == 'yes')){ ?>
						<div class="info-widget style-5">
							<?php if(!empty($general_phone_icon)){ ?>
							<div class="widget-media text-primary">
								<i class="<?php echo esc_attr($general_phone_icon); ?>"></i>
							</div>
							<?php } ?>
							<div class="widget-content">
								<?php if(!empty($general_phone_text)){ ?>
									<h6 class="title"><?php echo esc_html($general_phone_text); ?></h6>
								<?php }
								if(!empty($general_phone_number)){ ?>
									<a href="tel:<?php echo esc_url($general_phone_number); ?>" class="text-secondary"><?php echo esc_html($general_phone_number); ?></a>
								<?php } ?>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php if(!empty($img['id'])){ ?>
	<div class="dz-media">
		<img src="<?php echo esc_url($img['url']); ?>" alt="<?php echo esc_attr('Image','clinicmaster'); ?>">
	</div>
	<?php } ?>
</div>
<?php } ?>