<?php
$current_page = $GLOBALS['clinicmaster_query_result']['current_page'];
$posts_per_page = $GLOBALS['clinicmaster_query_result']['posts_per_page'];
$title_text_limit = $GLOBALS['clinicmaster_query_result']['title_text_limit'];
$element_style = $GLOBALS['clinicmaster_query_result']['element_style'];

$current_post_number =  (($current_page * $posts_per_page) - $posts_per_page) + 1;
$posts = $GLOBALS['clinicmaster_query_result']['posts']; /*NOTE - DO NOT PUT THIS LINE ABOVE OTHERWISE IT WILL GIVE NOTICE */

$num = 1;
foreach ($posts as $post) {

	$post_id  = $post->ID;
	$post_title = clinicmaster_trim(get_the_title(), $title_text_limit);
	$excerpt = $post->post_excerpt;
	$content = $post->post_content;

	/* implement post layout icons on listing post */
	$post_setting = get_post_meta($post_id, '_post_settings', true);
	$is_featured_post = isset($post_setting['is_featured_post']) ? $post_setting['is_featured_post'] : 0;
	$no_image_class = (!has_post_thumbnail()) ? 'no-image-box' : '';
	$designation = clinicmaster_get_post_meta(get_the_id(), 'team_designation');
	$team_social_data = clinicmaster_get_team_social_link($post_id);
	$class = ($num == 1) ? 'active' :'';
	if($element_style == 'style_1'){ 
?>
	<div id="post-<?php the_ID(); ?>" <?php echo post_class($no_image_class . ' ' . 'col-lg-4 col-sm-6 m-b30 wow fadeInUp'); ?> data-wow-delay="0.2s">
		<div class="dz-team style-1 <?php echo esc_attr($class); ?> box-hover">
			<?php if (has_post_thumbnail()) { ?>
			<div class="dz-media">
				<?php echo the_post_thumbnail('full'); ?>
				
				<?php  if(!empty($team_social_data['any_fill'] )){ ?>
					<ul class="dz-social">
					
						<?php foreach($team_social_data['data'] as $key => $value) {
							if(!empty($value['url'])){
						?>
							<li><a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['class']) ?>"></i></a></li>
						<?php }
							}
						?>	
					</ul>
				<?php } ?>
				
			</div>
			<?php } ?>
			<div class="dz-content">
				<div class="clearfix">
					<?php if( !empty($post_title) ){ ?>
					<h3 class="dz-name"><a href="<?php  echo esc_url(get_the_permalink($post)); ?>"><?php echo esc_html($post_title);  ?></a></h3>
					<?php }
					if( !empty($designation)){ ?> 
						<span class="dz-position"><?php echo esc_html($designation); ?></span>
					<?php } ?>
				
				</div>
			</div>
		</div>		
	</div>
	<?php }elseif($element_style == 'style_2'){ ?>
	<div id="post-<?php the_ID(); ?>" <?php echo post_class($no_image_class . ' ' . 'col-xl-3 col-sm-6 m-b30'); ?>>
	
		<div class="dz-team style-2 <?php echo esc_attr($class); ?> box-hover">
			<div class="dz-content">
				<?php if( !empty($post_title) ){ ?>
				<h3 class="dz-name"><a href="<?php  echo esc_url(get_the_permalink($post)); ?>"><?php echo esc_html($post_title);  ?></a></h3>
				<?php }
				if( !empty($designation)){ ?> 
					<span class="dz-position"><?php echo esc_html($designation); ?></span>
				<?php } ?>
				
			</div>
			<?php if (has_post_thumbnail()) { ?>
			<div class="dz-media">
				<?php echo the_post_thumbnail('clinicmaster_600x600'); ?>
			
				<?php  if(!empty($team_social_data['any_fill'] )){ ?>
					<ul class="dz-social">
					
						<?php foreach($team_social_data['data'] as $key => $value) {
							if(!empty($value['url'])){
						?>
							<li><a href="<?php echo esc_url($value['url']); ?>" target="_blank"><i class="<?php echo esc_attr($value['class']) ?>"></i></a></li>
						<?php }
							}
						?>	
					</ul>
				<?php } ?>
				
			</div>
			<?php } ?>
		</div>
	</div>
	
	
<?php
	} $num++;
}
wp_reset_postdata();
?>