<?php
$current_page = $GLOBALS['clinicmaster_query_result']['current_page'];
$posts_per_page = $GLOBALS['clinicmaster_query_result']['posts_per_page'];
$title_text_limit = $GLOBALS['clinicmaster_query_result']['title_text_limit'];
$show_column = $GLOBALS['clinicmaster_query_result']['show_column'];
$current_post_number =  (($current_page * $posts_per_page) - $posts_per_page) + 1;
$blog_view_container = !empty($GLOBALS['clinicmaster_query_result']['blog_view_container']) && $GLOBALS['clinicmaster_query_result']['blog_view_container'];
$posts = $GLOBALS['clinicmaster_query_result']['posts']; /*NOTE - DO NOT PUT THIS LINE ABOVE OTHERWISE IT WILL GIVE NOTICE */


if ($show_column == 'col_1') {
	$col_classes = 'col-lg-12 col-md-6 ';
} elseif ($show_column == 'col_2') {
	$col_classes = 'col-lg-6 col-md-6 ';
} elseif ($show_column == 'col_3') {
	$col_classes = 'col-lg-4 col-md-6 col-6 ';
} else {
	$col_classes = 'col-lg-3 col-6 col-md-6 ';
}

foreach ($posts as $post) {
	$product = wc_get_product($post->ID);
	$post_title = clinicmaster_trim($post->post_title, $title_text_limit);
	$img_id = get_post_thumbnail_id($post);
	$img_url = wp_get_attachment_image_src($img_id, 'clinicmaster_450X580');
	$featured = get_post_meta($post->ID, 'featured_post', true);
	$cat = get_the_terms($post->ID, 'product_cat');
	$term_class = '';
	$average      = $product->get_average_rating();
	
	if (!empty($cat)) {
		foreach ($cat as $term) {
			$term_class .= 'data-' . $term->slug.' ';
		}
	}
	
?>
<li class="card-container <?php echo esc_attr($col_classes .' '.$term_class); ?> m-b30 ">
	<div class="shop-card">
		<div class="dz-media">
			<?php if (!empty($img_id) && !empty($img_url[0])) { ?>
					<img src="<?php echo esc_url($img_url[0]); ?>" alt="<?php echo esc_attr__('Product Image', 'clinicmaster'); ?>">
			<?php } ?>
			<div class="shop-meta">
				<?php if (class_exists('YITH_WCQV')) { ?>
					<div class="woocommerce-quick-view">
						<a href="#" class="yith-wcqv-button btn quick-view" data-product_id="<?php echo esc_attr($product->get_id()); ?>">
							<span class="d-md-block d-none"><?php echo esc_html__('Quick View', 'clinicmaster'); ?></span>
						</a>
					</div>
				<?php } ?>

				<?php if (class_exists('YITH_WCWL')) { ?>
					<div class="woocommerce-wishlist">
						<?php
						echo do_shortcode('[yith_wcwl_add_to_wishlist  product_id="' . $product->get_id() . '" link_classes="add_to_wishlist btn meta-icon dz-wishicon" label="" product_added_text="" browse_wishlist_text="" already_in_wishslist_text="" icon="icon feather icon-heart dz-heart"]'); ?>
					</div>
				<?php  } ?>


				<?php if (clinicmaster_is_woo_catalog_shop_enable()) {
					echo sprintf(
						'<a rel="nofollow" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" class="%s product_type_simple btn meta-icon dz-carticon ">%s</a>',
						esc_url($product->add_to_cart_url()),
						esc_attr(!empty($quantity) ? $quantity : 1),
						esc_attr($product->get_id()),
						esc_attr($product->get_sku()),
						esc_attr(!empty($class) ? $class : 'add_to_cart_button ajax_add_to_cart'),
						'<i class="feather icon-shopping-cart"></i>'
					);
				} ?>
			</div>
			<?php if ( $product->is_on_sale() ){  ?>
			<div class="product-tag">
				<?php echo apply_filters( 'woocommerce_sale_flash', '<span class="badge ">'.esc_html__('SALE', 'clinicmaster').' '. esc_html__( 'Sale!', 'clinicmaster' ) .' '. esc_html__('OFF', 'clinicmaster').'</span>', $post, $product );  ?>
			</div>
			<?php } ?>
		</div>							
		<div class="dz-content">
			<div class="inner-content">
				<?php if (!empty($post_title)) { ?>
					<h3 class="title"><a href="<?php echo esc_url(get_permalink($post)); ?>"><?php echo esc_html($post_title); ?></a></h3>
				<?php } ?>
				<?php if (!function_exists('get_price_html')) { ?>
					<span class="price"><?php echo wp_kses($product->get_price_html(), clinicmaster_allowed_html_tag()); ?></span>
				<?php } ?>
			</div>
			<a href="<?php echo esc_url(get_permalink($post)); ?>" class="btn btn-square btn-lg btn-white btn-rounded shop-share-btn">
				<i class="feather icon-arrow-up-right"></i>
			</a>
		</div>
	</div>
</li>
<?php
}

wp_reset_postdata();
?>