/**
	Template Name 	 : ClinicMaster
	Author			 : KinixThemes
	
	Core script to handle the entire theme and core functions
**/

	// handleTestimonialSwiper1 Swiper ==
	var handleTestimonialSwiper1 = function() {	
		if(jQuery('.testimonial-swiper1').length > 0){
			var testimonialSwiper1 = new Swiper('.testimonial-swiper1', {
				loop: true,
				spaceBetween: 20,
				slidesPerView: 1,
				speed: 800,
				autoplay: {
					delay: 3000,
				},
				navigation:{
					nextEl: ".swiper1-button-next",
					prevEl: ".swiper1-button-prev",
				},
			});
		}	
	}
	
	// handleTestimonialSwiper2 Swiper ==
	var handleTestimonialSwiper2 = function() {	
		if(jQuery('.testimonial-swiper2').length > 0){
			var testimonialSwiper2 = new Swiper('.testimonial-swiper2', {
				loop: true,
				spaceBetween: 0,
				slidesPerView: 2,
				autoplay: {
					delay: 3000,
				},
				pagination: {
					el: ".testimonial-pagination-swiper2",
					type: "progressbar",
				},
				breakpoints: {
					1481: {
						slidesPerView: 2,
					},
					1280: {
						slidesPerView: 1.6,
					},
					991: {
						slidesPerView: 1.2,
					},
					320: {
						slidesPerView: 1,
					},
				},
			});
			if(jQuery('.testimonial-slider__pagination2').length > 0){
				function mainSliderPagination(){
					var swipertotalSlide = jQuery('.testimonial-swiper2 .swiper-slide').length;			
					var fragment = document.querySelector('.testimonial-slider__current');
					var fragment2 = document.querySelector('.testimonial-slider__total');
					var current = testimonialSwiper2.realIndex + 1;
					if (current > swipertotalSlide)
					current = 1;
					var idx = current < 10 ? ("0" + current) : current;
					var tdx = swipertotalSlide < 10 ? ("0" + swipertotalSlide) : swipertotalSlide;
					fragment2.innerHTML = (tdx);
					fragment.innerHTML = (idx);
				}
				mainSliderPagination();
				testimonialSwiper2.on('slideChange', function() {
					mainSliderPagination();
				});
			}
		}	
	}
	
	// handleTestimonialSwiper3 Swiper ==
	var handleTestimonialSwiper3 = function() {	
		if(jQuery('.testimonial-swiper3').length > 0){
			var testimonialSwiper3 = new Swiper('.testimonial-swiper3', {
				loop: true,
				spaceBetween: 0,
				slidesPerView: 1,
				autoplay: {
					delay: 3000,
				},
				pagination: {
					el: ".testimonial-pagination-swiper3",
					clickable: true,
				},
			});
		}	
	}
	
	// handleTestimonialSwiper4 Swiper ==
	var handleTestimonialSwiper4 = function() {	
		if(jQuery('.testimonial-swiper4').length > 0){
			var testimonialThumbSwiper4 = new Swiper(".testimonial-thumb-swiper4", {
				slidesPerView: "1",
				effect: "fade",
				centeredSlides: true,
			});
			var testimonialSwiper4 = new Swiper('.testimonial-swiper4', {
				loop: true,
				spaceBetween: 20,
				slidesPerView: 1,
				centeredSlides: true,
				autoplay: {
					delay: 3000,
				},
				thumbs: {
					swiper: testimonialThumbSwiper4,
				},
				navigation:{
					nextEl: ".swiper4-button-next",
					prevEl: ".swiper4-button-prev",
				},
			});
		}
	}
	
	// handleTestimonialSwiper5 Swiper ==
	var handleTestimonialSwiper5 = function() {	
		if(jQuery('.testimonial-swiper5').length > 0){
			var testimonialSwiper5 = new Swiper('.testimonial-swiper5', {
				loop: true,
				spaceBetween: 20,
				slidesPerView: 3,
				autoplay: {
					delay: 3000,
				},
				pagination: {
					el: ".testimonial-pagination-swiper2",
					type: "progressbar",
				},
				breakpoints: {
					1481: {
						slidesPerView: 3,
					},
					1280: {
						slidesPerView: 1.6,
					},
					991: {
						slidesPerView: 1.2,
					},
					320: {
						slidesPerView: 1,
					},
				},
			});
		}	
	}
	
	// handleAwardSlider Swiper ==
	var handleAwardSlider = function() {	
		if(jQuery('.awards-swiper').length > 0){
			var swiperBook = new Swiper('.awards-swiper', {
				loop: true,
				slidesPerView: 5,
				autoplay: {
					delay: 3000,
				},
				breakpoints: {
					1440: {
						slidesPerView: 5,
					},
					991: {
						slidesPerView: 4,
					},
					767: {
						slidesPerView: 3,
					},
					575: {
						slidesPerView: 2.5,
					},
					320: {
						slidesPerView: 1.5,
					},
				},
			});
		}
	}
	
	// handleDzTeamSwiper1 Swiper ==
	var handleDzTeamSwiper1 = function() {	
		if(jQuery('.dz-team-swiper1').length > 0){
			var teamSwiperThumb = new Swiper(".dz-team-swiper1-thumb", {
				slidesPerView: "2",
				grid:{
					rows: 2,
				},
				autoplay: {
					delay: 3000,
				},
				breakpoints: {
					320: {
						slidesPerView: 1.2,
						grid:{
							rows: 1,
						},
					},
					591: {
						slidesPerView: 2,
					},
					991: {
						slidesPerView: 3,
					},
					1200: {
						slidesPerView: 2,
					},
				}
			});
			var teamSwiper = new Swiper(".dz-team-swiper1", {
				slidesPerView: "1",
				effect: "fade",
				thumbs: {
					swiper: teamSwiperThumb,
				},
				pagination: {
					el: ".team-progressbar-swiper",
					type: "progressbar",
				},
				navigation: {
					nextEl: ".team-swiper-next",
					prevEl: ".team-swiper-prev",
				},
			});
			if(jQuery('.team-pagination-swiper').length > 0){
				function mainSliderPagination(){
					var swipertotalSlide = jQuery('.dz-team-swiper1 .swiper-slide').length;			
					var fragment = document.querySelector('.team-slider__current');
					var fragment2 = document.querySelector('.team-slider__total');
					var current = teamSwiper.realIndex + 1;
					if (current > swipertotalSlide)
					current = 1;
					var idx = current < 10 ? ("0" + current) : current;
					var tdx = swipertotalSlide < 10 ? ("0" + swipertotalSlide) : swipertotalSlide;
					fragment2.innerHTML = (tdx);
					fragment.innerHTML = (idx);
				}
				mainSliderPagination();
				teamSwiper.on('slideChange', function() {
					mainSliderPagination();
				});
			}
		}
	}
	
	// handleAwardSlider Swiper ==
	var handleDzTeamSwiper2 = function() {	
		if(jQuery('.dz-team-swiper2').length > 0){
			var teamSwiper2 = new Swiper('.dz-team-swiper2', {
				loop: true,
				slidesPerView: 3,
				speed: 800,
				autoplay: {
					delay: 3000,
				},
				navigation: {
					nextEl: ".team-swiper-next",
					prevEl: ".team-swiper-prev",
				},
				pagination: {
					el: ".swiper-pagination",
					clickable: true,
				},
				breakpoints: {
					1200: {
						slidesPerView: 3,
						spaceBetween: 40,
					},
					767: {
						slidesPerView: 2,
						spaceBetween: 30,
					},
					320: {
						slidesPerView: 1,
						spaceBetween: 20,
					},
				},
			});
		}
	}
	
	// Project Carousel Swiper ==
	var handleVerticalSwiper = function() {	
		if(jQuery('.blog-vertical-swiper').length > 0){
			var teamSwiperThumb = new Swiper(".blog-vertical-swiper-thumb", {
				direction: "vertical",
				slidesPerView: "3",
				mousewheel: false,
				autoplay: {
					delay: 3000,
				},
				breakpoints: {
					320: {
						slidesPerView: 1,
						direction: "horizontal",
					},
					767: {
						slidesPerView: 2,
						direction: "vertical",
					},
					1191: {
						slidesPerView: 3,
					},
				}
			});
			var teamSwiper = new Swiper(".blog-vertical-swiper", {
				slidesPerView: "1",
				effect: "fade",
				grabCursor: true,
				thumbs: {
					swiper: teamSwiperThumb,
				},
				navigation: {
					nextEl: ".blog-swiper-next",
					prevEl: ".blog-swiper-prev",
				},
			});
		}
	}
	
	// handleAwardSlider Swiper ==
	var handleClientSwiper = function() {	
		if(jQuery('.client-swiper').length > 0){
			var swiperClient = new Swiper('.client-swiper', {
				loop: true,
				slidesPerView: 5,
				spaceBetween: 30,
				autoplay: {
					delay: 3000,
				},
				breakpoints: {
					1200: {
						slidesPerView: 6,
					},
					991: {
						slidesPerView: 4,
					},
					575: {
						slidesPerView: 3,
					},
					320: {
						slidesPerView: 2,
					},
				},
			});
		}
	}
	
	// handleAwardSlider Swiper 2 ==
	var handleClientSwiper2 = function() {	
		if(jQuery('.client-swiper2').length > 0){
			var swiperClient = new Swiper('.client-swiper2', {
				loop: true,
				slidesPerView: 4,
				spaceBetween: 30,
				autoplay: {
					delay: 3000,
				},
				breakpoints: {
					767: {
						slidesPerView: 4,
					},
					575: {
						slidesPerView: 3,
					},
					320: {
						slidesPerView: 2,
					},
				},
			});
		}
	}
	
	var handleDzFlexSwiper = function () {
		if (jQuery('.dz-flex-swiper').length > 0) {
			var swiper = new Swiper('.dz-flex-swiper', {
				speed: 500,
				loop: false,
				slidesPerView: 'auto',
				spaceBetween: 0,
				autoplay: {
					delay: 3000,
				},
				breakpoints: {
					991: {
				 		slidesPerView: 'auto',
				 	},
					320: {
				 		slidesPerView: 1,
				 	},
				}
			});
		}
	}
	
	// handleTestimonialSwiper2 Swiper ==
	var handleCompareSwiper = function() {	
		if(jQuery('.compare-swiper').length > 0){
			var compareSwiper = new Swiper(".compare-swiper", {
				loop: true,
				slidesPerView: 4,
				spaceBetween: 20,
				centeredSlides: true,
				autoplay: {
					delay: 3000,
				},
				navigation: {
					nextEl: ".compare-swiper-next",
					prevEl: ".compare-swiper-prev",
				},
				pagination: {
					el: ".compare-pagination-swiper",
					type: "progressbar",
				},
				breakpoints: {
					1481: {
						slidesPerView: 4.4,
					},
					1280: {
						slidesPerView: 4,
					},
					991: {
						slidesPerView: 3.5
					},
					320: {
						slidesPerView: 2,
					},
				},
			});
			if(jQuery('.compare-slider__pagination').length > 0){
				function mainSliderPagination(){
					var swipertotalSlide = jQuery('.compare-swiper .swiper-slide').length;			
					var fragment = document.querySelector('.compare-slider__current');
					var fragment2 = document.querySelector('.compare-slider__total');
					var current = compareSwiper.realIndex + 1;
					if (current > swipertotalSlide)
					current = 1;
					var idx = current < 10 ? ("0" + current) : current;
					var tdx = swipertotalSlide < 10 ? ("0" + swipertotalSlide) : swipertotalSlide;
					fragment2.innerHTML = (tdx);
					fragment.innerHTML = (idx);
				}
				mainSliderPagination();
				compareSwiper.on('slideChange', function() {
					mainSliderPagination();
				});
			}
		}	
	}
	var handleTwentytwenty = function(){
		if((jQuery('.twentytwenty-container').length > 0)){
			jQuery(".twentytwenty-container[data-orientation!='vertical']").twentytwenty({
				default_offset_pct: 0.5,
			});
		}
	}
	var handleBlogSlidesShow = function(){
		if(jQuery('.blog-slideshow').length > 0){
			var blogSwiper = new Swiper('.blog-slideshow', {
				speed: 1500,
				slidesPerView: 1,
				loop:true,
				pagination: {
					el: ".swiper-pagination-two",
					clickable: true,
				},
				autoplay: {
				   delay: 3000,
				},
			});
		}
	}

	function handlePostSlider(){
		 /* Blog Swiper */
		if(jQuery('.post-swiper-two').length > 0){
			var swiper = new Swiper('.post-swiper-two', {
				loop: true,
				spaceBetween: 10, 
				slidesPerView: 4,
				freeMode: true,
				watchSlidesVisibility: true,
				watchSlidesProgress: true,
			});
			var swiper2 = new Swiper('.post-swiper-2', {
				loop: true,
				spaceBetween: 10,
				navigation: {
				  nextEl: ".swiper-button-next",
				  prevEl: ".swiper-button-prev",
				},
				thumbs: {
				  swiper: swiper,
				},
			});
		}
	}
	// DZ Flex Wrapper ============
	var handleFlexWrapper = function(){
		const flexItem = document.querySelectorAll('.dz-flex-wrapper .dz-flex-item');
		
		if (flexItem) {
			flexItem.forEach(function(element) {
				element.addEventListener('click', function() {
					flexItem.forEach(function(item) {
						item.classList.remove('active');
					});
					element.classList.add('active');
				});
			});
		}
	}

	
	var handlePricingTabs = function(){
		const toggleTabs = document.querySelector('.toggle-tabs');
		
		if (toggleTabs) {
			const priceYear = document.querySelectorAll('.pricingtable-price.year');
			const priceMonth = document.querySelectorAll('.pricingtable-price.month');
			
			priceYear.forEach(function(element){
				element.style.display = 'none';
			});
			
			const toggleTabsMonthly = document.querySelector('.toggle-tabs .monthly');
			const toggleTabsYearly = document.querySelector('.toggle-tabs .yearly');
			
			toggleTabsMonthly.addEventListener('click', function(){
				toggleTabs.classList.remove('yearly');
				toggleTabs.classList.add('monthly');
				
				priceMonth.forEach(function(element){
					element.style.display = 'block';
				});
				priceYear.forEach(function(element){
					element.style.display = 'none';
				});
			});
			
			toggleTabsYearly.addEventListener('click', function(){
				toggleTabs.classList.remove('monthly');
				toggleTabs.classList.add('yearly');
				
				priceMonth.forEach(function(element){
					element.style.display = 'none';
				});
				priceYear.forEach(function(element){
					element.style.display = 'block';
				});
			});
		}
	}
	
	
	// Date Time Picker ============
	var handleTempusDominus = function () {
		const datePickerOnly = document.getElementById('datePickerOnly');
		if (datePickerOnly) {
			const td = new tempusDominus.TempusDominus(datePickerOnly, {
				display: {
					viewMode: "calendar",
					components: {
						decades: true,
						year: true,
						month: true,
						date: true,
						hours: false,
						minutes: false,
						seconds: false
					},
				},
				localization: {
					locale: 'en',
					format: 'dd/MM/yyyy',
				}

			});
		}
		
		const timePickerOnly = document.getElementById('timePickerOnly');
		if (timePickerOnly) {
			new tempusDominus.TempusDominus(timePickerOnly, {
				display: {
					viewMode: "clock",
					components: {
						decades: false,
						year: false,
						month: false,
						date: false,
						hours: true,
						minutes: true,
						seconds: false
					}
				},
				localization: {
					locale: 'en',
					format: 'HH:mm',
				}
			});
		}
		
		const dateTimePickerOnly = document.getElementById('dateTimePickerOnly');
		if (dateTimePickerOnly) {
			new tempusDominus.TempusDominus(dateTimePickerOnly, {
				display: {
					viewMode: "calendar",
					components: {
						decades: true,
						year: true,
						month: true,
						date: true,
						hours: true,
						minutes: true,
						seconds: false // Set to true if you want to include seconds
					}
				},
				localization: {
					locale: 'en',
					format: 'dd/MM/yyyy HH:mm',
				}
			});
		}
	}
	// handle Text Char ============
	var handleTextChar = function () {
		var wordRotateElements = document.querySelectorAll('.word-rotate');
		
		if(wordRotateElements){
			wordRotateElements.forEach((data) => {
				var wordRotate = data.textContent.split('');
				const step = 360 / wordRotate.length;
				
				var wordRotateBox = data.closest('.word-rotate-box');
				
				wordRotate.forEach((el, i) => {
					const span = document.createElement('span');
					span.className = 'text__char';
					span.style.setProperty('--char-rotate', (i * step) + 'deg');
					span.textContent = el;
					wordRotateBox.appendChild(span);
				})
				data.remove();
			});
		}
	}
	

/* Document.ready Start */	
jQuery(document).ready(function() {
   
	
	handleTestimonialSwiper1();
	handleTestimonialSwiper2();
	handleTestimonialSwiper3();
	handleTestimonialSwiper4();
	handleTestimonialSwiper5();
	handleAwardSlider();
	handleDzTeamSwiper1();
	handleDzTeamSwiper2();
	handleClientSwiper();
	handleClientSwiper2();
	handleVerticalSwiper();
	handleDzFlexSwiper();
	handleCompareSwiper();
	handleTwentytwenty();
	handleBlogSlidesShow();
	handlePostSlider();
	handleFlexWrapper();
	handleTextChar();
	handleTempusDominus();
	handlePricingTabs();
	
	
});
/* Document.ready END */

/* Window Load START */
jQuery(window).on('load',function () {
	
	
});
/*  Window Load END */

/* Window Resize START */
jQuery(window).on('resize',function () {
	 
	handleVerticalSwiper();
});
/*  Window Resize END */