<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZUserProfile extends Widget_Base 
{
	public function get_name() {
		return 'dz-user-profile';
	}
	
	public function get_title() {
		return esc_html__('User Profile',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-person';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'user_profile_element_style',
			[
				'label' 	 => esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Style', DZ_TH_DOMAIN),
								'style_1' => esc_html__('Style 1',DZ_TH_DOMAIN),
								'style_2' => esc_html__('Style 2',DZ_TH_DOMAIN),
								'style_3' => esc_html__('Style 3',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'style_1',
				
			]
		);
		
		$this->add_control(
			'user_profile_element_subtitle',
			[
				'label' 		=> esc_html__( 'SubTitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your subtitle', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Best Dentist', DZ_TH_DOMAIN )
			]
		);
		
		$this->add_control(
			'user_profile_element_icon_img',
			[
				'label' 		=> esc_html__( 'Sub Icon Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'user_profile_element_style' => ['style_1'],
				],
			]
		);
		
		
		
		$this->add_control(
			'user_profile_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Meet Dr. Natali jackson', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'user_profile_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   	=> '<strong class="text-secondary fw-semibold">'.esc_html__( 'Dr. Natali jackson', DZ_TH_DOMAIN ).'</strong>'.esc_html__( ' There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'user_profile_element_img',
			[
				'label' 		=> esc_html__( 'Upload Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$this->add_control(
			'user_profile_element_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'user_profile_element_style' => 'style_1',
				],
			]
		);
		$this->add_control(
			'user_profile_element_feature_title',
			[
				'label' 		=> esc_html__( 'Feature Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'About Skills', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'user_profile_element_feature_description',
			[
				'label' 	=> esc_html__( 'Feature Listing. ( Comma Seperated)', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'separator'	=>  'default',
				'rows'		=>  5,
				'default'   	=> esc_html__( 'Radiant Skin Dermatology, Laser Resurfacing, Flawless Dermatology, Refined Skin Dermatology, Luminous Dermatology, Anti Aging', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'user_profile_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
				'condition' => [
					'user_profile_element_style' => ['style_2','style_3'],
				],
			]
		);
		$this->add_control(
			'user_profile_element_signechar_img',
			[
				'label' 		=> esc_html__( 'Signechar Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'user_profile_element_style' => ['style_2','style_3'],
				],
			]
		);
		$this->add_control(
			'user_profile_element_signechar_text',
			[
				'label' 		=> esc_html__( 'Signechar Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Dr. Nashid Martines', DZ_TH_DOMAIN ),
				'condition' => [
					'user_profile_element_style' => ['style_2','style_3'],
				],
			]
		);
		$this->add_control(
			'user_profile_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Appointment', DZ_TH_DOMAIN ),
				'condition' => [
					'user_profile_element_style' => ['style_2','style_3'],
				],
			]
		);
		$this->add_control(
			'user_profile_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your url', DZ_TH_DOMAIN ),
				'condition' => [
					'user_profile_element_style' => ['style_2','style_3'],
				],
				
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'gift',
			[
				'label' => esc_html__( 'Gift', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'user_profile_element_gift_title',
			[
				'label' 		=> esc_html__( 'Gift Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'ClinicMaster 2024', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'user_profile_element_gift_description',
			[
				'label' 	=> esc_html__( 'Gift Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Quality and Accreditation Institute', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'user_profile_element_gift_img',
			[
				'label' 		=> esc_html__( 'Gift Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$this->add_control(
			'user_profile_element_text',
			[
				'label' 		=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Best Dermatologists', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'user_profile_element_text_link',
			[
				'label' 		=> esc_html__( 'Text Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'user_profile_element_gift_title2',
			[
				'label' 		=> esc_html__( 'Gift Title 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'ClinicMaster 2024', DZ_TH_DOMAIN ),
				'condition' => [
					'user_profile_element_style' => 'style_1',
				],
			]
		);
		
		
		$this->add_control(
			'user_profile_element_gift_description2',
			[
				'label' 	=> esc_html__( 'Gift Description 2 .', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Quality and Accreditation Institute', DZ_TH_DOMAIN ),
				'condition' => [
					'user_profile_element_style' => 'style_1',
				],
			]
		);
		$this->add_control(
			'user_profile_element_gift_img2',
			[
				'label' 		=> esc_html__( 'Gift Image 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'user_profile_element_style' => 'style_1',
				],
			]
		);
		$this->add_control(
			'user_profile_element_text2',
			[
				'label' 		=> esc_html__( 'Text 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Best Dermatologists', DZ_TH_DOMAIN ),
				'condition' => [
					'user_profile_element_style' => 'style_1',
				],
			]
		);
		$this->add_control(
			'user_profile_element_text_link2',
			[
				'label' 		=> esc_html__( 'Text Link 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
				'condition' => [
					'user_profile_element_style' => 'style_1',
				],
			]
		);
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'counter',
			[
				'label' => esc_html__( 'Counter Box', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'user_profile_element_counter_number',
			[
				'label' 		=> esc_html__( 'Counter Number', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your counter number', DZ_TH_DOMAIN ),
				'default'   	=> '20',
			]
		);
		$this->add_control(
			'user_profile_element_counter_symbol',
			[
				'label' 		=> esc_html__( 'Symbol', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your counter number', DZ_TH_DOMAIN ),
				'default'   	=> '+',
			]
		);
		
		$this->add_control(
			'user_profile_element_counter_text',
			[
				'label' 		=> esc_html__( 'Counter Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Years', DZ_TH_DOMAIN ).'<br>'. esc_html__( 'Experienced', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->end_controls_section();
		
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/user_profile_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}