<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZTeamDetail1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-team-detail-1';
	}
	
	public function get_title() {
		return esc_html__('Team Detail 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'team_detail_1_element_style',
			[
				'label' 		=> esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options' 	=> 	array(
					'style_1' => esc_html__( 'Style 1', DZ_TH_DOMAIN ),
					'style_2' => esc_html__( 'Style 2', DZ_TH_DOMAIN ),
					
				),
				'default'   => 'style_1',
				
			]
		);
		
		$this->add_control(
			'team_detail_1_element_education',
			[
				'label' 		=> esc_html__( 'Education', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'MBBS (Village Town), USA (Cardiac Surgery)', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'team_detail_1_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters,', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'team_detail_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Make An ', DZ_TH_DOMAIN ).'<span>'.esc_html__( 'Appointment ', DZ_TH_DOMAIN ).'</span> <br>'.esc_html__( 'Apply For Treatments ', DZ_TH_DOMAIN ),
				'condition' => [
					'team_detail_1_element_style' => 'style_1',
				],
			]
		);
		
		
		$this->add_control(
		'team_detail_1_element_contact_form',
			[
				'label' 	 => esc_html__( 'Contact Form', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_contact_form_list(),
				'default'	 => '',
				'condition' => [
					'team_detail_1_element_style' => 'style_1',
				],
			]
		);
		$this->add_control(
			'team_detail_1_element_counter_number',
			[
				'label' 		=> esc_html__( 'Counter Number', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your number', DZ_TH_DOMAIN ),
				'default' 	=> '20',
				'condition' => [
					'team_detail_1_element_style' => 'style_2',
				],
			]
		);
		$this->add_control(
			'team_detail_1_element_counter_symbol',
			[
				'label' 		=> esc_html__( 'Counter Symbol', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your symbol', DZ_TH_DOMAIN ),
				'default' 	=> '+',
				'condition' => [
					'team_detail_1_element_style' => 'style_2',
				],
				
			]
		);				
		$this->add_control(
			'team_detail_1_element_counter_text',
			[
				'label' 		=> esc_html__( 'Counter Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Years ', DZ_TH_DOMAIN ).'<br>'.esc_html__( 'Experienced ', DZ_TH_DOMAIN ),
				'condition' => [
					'team_detail_1_element_style' => 'style_2',
				],
			]
		);
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'user_information',
			[
				'label' => esc_html__( 'User Information', DZ_TH_DOMAIN ),
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'team_detail_1_element_item_text',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Specialty', DZ_TH_DOMAIN ),
			]
		);
		
		
		$repeater->add_control(
			'team_detail_1_element_item_value',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Orthodontist Surgeon Specialize', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'team_detail_1_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'team_detail_1_element_item_text' 		=> esc_html__( 'Specialty', DZ_TH_DOMAIN ),
						'team_detail_1_element_item_value' 		=> esc_html__( 'Orthodontist Surgeon Specialize', DZ_TH_DOMAIN ),
						
					],	
					[	
						'team_detail_1_element_item_text' 		=> esc_html__( 'Degrees', DZ_TH_DOMAIN ),
						'team_detail_1_element_item_value' 		=> '<a href="javascript:void(0);">'.esc_html__( 'MBBS University of California', DZ_TH_DOMAIN ).'</a>',
						
					],	
					[	
						'team_detail_1_element_item_text' 		=> esc_html__( 'Experience', DZ_TH_DOMAIN ),
						'team_detail_1_element_item_value' 		=> esc_html__( '7 years, New York Urgent Medical Care Serving California', DZ_TH_DOMAIN ),
						
					],	
					[	
						'team_detail_1_element_item_text' 		=> esc_html__( 'Awards', DZ_TH_DOMAIN ),
						'team_detail_1_element_item_value' 		=> esc_html__( '2018 - 2019 : William Allan Award', DZ_TH_DOMAIN ),
						
					],	
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'skils',
			[
				'label' => esc_html__( 'User Skills', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'team_detail_1_element_feature_text',
			[
				'label' 		=> esc_html__( 'Feature Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Professional Skills', DZ_TH_DOMAIN ),
			]
		);
		
		
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'team_detail_1_element_feature_list',
			[
				'label' 		=> esc_html__( 'Feature List', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( 'Radiant Skin Dermatology', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater->add_control(
			'team_detail_1_element_feature_number',
			[
				'label' 		=> esc_html__( 'Professional ', DZ_TH_DOMAIN ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'default' => 90,
			]
		);
		
		
		$this->add_control(
			'team_detail_1_element_skils',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'team_detail_1_element_feature_list' 		=> esc_html__( 'Radiant Skin Dermatology', DZ_TH_DOMAIN ),
						'team_detail_1_element_feature_number' 		=> '',
					],	
					[	
						'team_detail_1_element_feature_list' 		=> esc_html__( 'Laser Resurfacing', DZ_TH_DOMAIN ),
						'team_detail_1_element_feature_number' 		=> '',
					],
					[	
						'team_detail_1_element_feature_list' 		=> esc_html__( 'Flawless Dermatology', DZ_TH_DOMAIN ),
						'team_detail_1_element_feature_number' 		=> '',
					],	
					[	
						'team_detail_1_element_feature_list' 		=> esc_html__( 'Refined Skin Dermatology', DZ_TH_DOMAIN ),
						'team_detail_1_element_feature_number' 		=> '',
					],
					[	
						'team_detail_1_element_feature_list' 		=> esc_html__( 'Luminous Dermatology', DZ_TH_DOMAIN ),
						'team_detail_1_element_feature_number' 		=> '',
					],
					[	
						'team_detail_1_element_feature_list' 		=> esc_html__( 'Anti Aging', DZ_TH_DOMAIN ),
						'team_detail_1_element_feature_number' 		=> '',
					],
					
				],
			]
		);
		
		
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'contact',
			[
				'label' => esc_html__( 'Contact Info', DZ_TH_DOMAIN ),
				
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'team_detail_1_element_contact_icon',
			[
				'label' 	=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::ICONS,
				
			]
		);
		
		$repeater->add_control(
			'team_detail_1_element_contact_text',
			[
				'label' 	=> esc_html__( 'Taxt', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Address', DZ_TH_DOMAIN ),
				
			]
		);
		$repeater->add_control(
			'team_detail_1_element_contact_value',
			[
				'label' 	=> esc_html__( 'Value', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your value', DZ_TH_DOMAIN ),
				'default' => esc_html__( '234 Oak Drive, Villagetown, USA', DZ_TH_DOMAIN ),
				
			]
			
		);
		$this->add_control(
			'team_detail_1_element_contact',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition' => [
					'team_detail_1_element_style' => 'style_1',
				],
				'default' 		=> [
					[	
						'team_detail_1_element_contact_text' 		=> esc_html__( 'Address', DZ_TH_DOMAIN ),
						'team_detail_1_element_contact_value' 		=> esc_html__( '234 Oak Drive, Villagetown, USA', DZ_TH_DOMAIN ),
					],	
					[	
						'team_detail_1_element_contact_text' 		=> esc_html__( 'Call Us', DZ_TH_DOMAIN ),
						'team_detail_1_element_contact_value' 		=> esc_html__( '+1 123 456 7890', DZ_TH_DOMAIN ),
					],	
					[	
						'team_detail_1_element_contact_text' 		=> esc_html__( 'Send us a Mail', DZ_TH_DOMAIN ),
						'team_detail_1_element_contact_value' 		=> esc_html__( 'info@example.com', DZ_TH_DOMAIN ),
					],	
					
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'schedule',
			[
				'label' => esc_html__( 'Time Schedule', DZ_TH_DOMAIN ),
				'condition' => [
					'team_detail_1_element_style' => 'style_1',
				],
			]
		);
		
		$this->add_control(
			'team_detail_1_element_text',
			[
				'label' 	=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'My Time Schedule', DZ_TH_DOMAIN ),
				'condition' => [
					'team_detail_1_element_style' => 'style_1',
				],
			]
		);
		
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'team_detail_1_element_schedule_week',
			[
				'label' 	=> esc_html__( 'Week  Name', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Monday - Friday', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'team_detail_1_element_schedule_time',
			[
				'label' 	=> esc_html__( 'Time Schedule', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your time', DZ_TH_DOMAIN ),
				'default' => '09:30 - 07:30',
			]
		);
		$this->add_control(
			'team_detail_1_element_schedule',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'condition' => [
					'team_detail_1_element_style' => 'style_1',
				],
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[	
						'team_detail_1_element_schedule_week' 		=> esc_html__( 'Monday - Friday', DZ_TH_DOMAIN ),
						'team_detail_1_element_schedule_time' 		=> '09:30 - 07:30',
					],	
					[	
						'team_detail_1_element_schedule_week' 		=> esc_html__( 'Saturday', DZ_TH_DOMAIN ),
						'team_detail_1_element_schedule_time' 		=> '09:30 - 04:30',
					],	
					[	
						'team_detail_1_element_schedule_week' 		=> esc_html__( 'Sunday', DZ_TH_DOMAIN ),
						'team_detail_1_element_schedule_time' 		=> '09:30 - 04:30',
					],	
					
					
				],
			]
		);
		$this->end_controls_section();
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'team_detail_1_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/team_detail_1_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}