<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZProcessFlow extends Widget_Base 
{
	public function get_name() {
		return 'dz-process-flow';
	}
	
	public function get_title() {
		return esc_html__('Process Flow',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'process_flow_element_style',
			[
				'label' 	 => esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Style', DZ_TH_DOMAIN),
								'style_1' => esc_html__('Style 1',DZ_TH_DOMAIN),
								'style_2' => esc_html__('Style 2',DZ_TH_DOMAIN),
								
							),				
				'default'	 =>  'style_1',
				
			]
		);
		
		
		$this->add_control(
			'process_flow_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Dental Implant Process', DZ_TH_DOMAIN ),
				'condition' => [
					'process_flow_element_style' => 'style_1',
				],
			]
		);
		
		
		$this->add_control(
			'process_flow_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'The dental implant process involves several stages to ensure successful placement and integration of the implant:', DZ_TH_DOMAIN ),
				'condition' => [
					'process_flow_element_style' => 'style_1',
				],
			]
		);
		
	
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'process_flow_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Initial Consultation and Planning', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'process_flow_element_item_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'A comprehensive examination, including X-rays and scans, is conducted to assess dental health and create a detailed treatment plan.', DZ_TH_DOMAIN ),
						
			]
		);
		
		$this->add_control(
			'process_flow_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'item_actions' => [
					'add'       => false,
					'duplicate' => false,
					'remove'    => false,
					'sort'      => true,
				],
				'default' 		=> [
					[	
						'process_flow_element_item_title' 		=> esc_html__( 'Initial Consultation and Planning', DZ_TH_DOMAIN ),
						'process_flow_element_item_description' => esc_html__( 'A comprehensive examination, including X-rays and scans, is conducted to assess dental health and create a detailed treatment plan.', DZ_TH_DOMAIN ),
						
					],	
					[	
						'process_flow_element_item_title' 		=> esc_html__( 'Implant And Placement', DZ_TH_DOMAIN ),
						'process_flow_element_item_description' => esc_html__( 'The dental implant, a titanium post, is surgically placed into the jawbone to serve as an artificial root for the replacement tooth.', DZ_TH_DOMAIN ),
						
					],	
					[	
						'process_flow_element_item_title' 		=> esc_html__( 'ealing and Osseointegration', DZ_TH_DOMAIN ),
						'process_flow_element_item_description' => esc_html__( 'Over several months, the implant fuses with the jawbone, providing a stable foundation for the replacement tooth.', DZ_TH_DOMAIN ),
						
					],	
					[	
						'process_flow_element_item_title' 		=> esc_html__( 'Abutment and Crown Placement', DZ_TH_DOMAIN ),
						'process_flow_element_item_description' => esc_html__( 'An abutment is attached to the implant, and a custom-made crown is placed on the abutment, completing the restoration with a natural-looking and functional tooth.', DZ_TH_DOMAIN ),
						
					],	
					
				],
			]
		);
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'process_flow_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/process_flow_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}