<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZPostSlider1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-post-slider-1';
	}
	
	public function get_title() {
		return esc_html__('Post Slider 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-nested-carousel';
	}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_slider_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Stay Informed with', DZ_TH_DOMAIN ) .'<br>'. esc_html__( 'Our Latest Health Blogs', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_slider_1_element_btn_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> esc_html__( 'View All', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'post_slider_1_element_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
				'default'		=>  'https://clinicmaster.wprdx.com/demo/blog',
				
			]
		);	
		
		$this->add_control(
			'post_slider_1_element_posts_in_categories',
			[
				'label' 		=> esc_html__( 'Include These Categories', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'type' 		 	=> Controls_Manager::SELECT2,
				'options'		=> dz_get_categories(array( 'taxonomy' => 'category'),true),				
				'description'	=> esc_html__( 'Select multiple/ single categories', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_slider_1_element_only_featured_posts',
			[
				'label' 		=> esc_html__( 'Include Only Featured Posts', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SWITCHER,
				'return_value' 	=> 'yes',
				'description'	=> esc_html__( 'Choose to show only featured posts.', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'advance',
			[
				'label' => esc_html__( 'Advance', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_slider_1_element_text_limit',
			[
				'label' 		=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'		=>  7,
				'min'           => 0,
				'title'			=> esc_html__( 'Text Limit', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter Text Limit', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_slider_1_element_no_of_posts',
			[
				'label' 		=> esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::NUMBER,
				'default'	 	=>  8,
				'min'           => 0,
				'title'			=>  esc_html__( 'No. Of Posts Per Page', DZ_TH_DOMAIN ),
				'description'	=> esc_html__( 'Enter no. of posts to show per page.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'post_slider_1_element_image_preference',
			[
				'label' 		=> esc_html__( 'Post Image Preference', DZ_TH_DOMAIN ),
				'show_label'	=> true,
				'label_block' 	=> true,
				'type' 		 	=> Controls_Manager::SELECT,
				'options'		=> dz_get_image_preference_options_list(),				
				'default'		=>  'image_post_only',
			]
		);
		
		$this->add_control(
			'post_slider_1_element_orderby',
			[
				'label' 		   => esc_html__( 'Order By', DZ_TH_DOMAIN ),
				'show_label'	   => true,
				'label_block' 	   => true,
				'type' 		 	   => Controls_Manager::SELECT,
				'options'		   => dz_get_orderby_options_list2(),				
				'default'		   => 'date' ,
			]
		);
		
		$this->add_control(
			'post_slider_1_element_order',
			[
				'label' 	 => esc_html__( 'Order', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_order_options_list(),
				'default'	 =>  'ASC',
			]
		);
		
		
		
	$this->end_controls_section();
	
	/* Swiper Controls End */
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/post_slider_1_element.php',$settings);
		
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handleVerticalSwiper();
					}					
				});
			 </script>
			";
	}
	
	protected function content_template() 
	{

    }
}