<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner3 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-3';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 3',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-banner';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_3_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Skincare is Like A Workout For Your Skin', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'home_banner_3_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Experienced staff is dedicated to improving our patients’ dental health and enhancing', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_3_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'home_banner_3_element_social',
			[
				'label' => esc_html__( 'Show Social', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'home_banner_3_element_fun_fact',
			[
				'label' 		=> esc_html__( 'Fun Fact Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'LET’S TALK', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_3_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'appointment', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_3_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
				
			]
		);
		$this->add_control(
			'home_banner_3_element_youtube_taxt',
			[
				'label' 		=> esc_html__( 'YouTube Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'More Collection Explore', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_3_element_youtube_link',
			[
				'label' 		=> esc_html__( 'YouTube Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your url', DZ_TH_DOMAIN ),
				'default'   => 'https://www.youtube.com/watch?v=YwYoyQ1JdpQ',
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'gallery',
			[
				'label' => esc_html__( 'Gallery', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_3_element_gallery_img',
			[
				'label' 		=> esc_html__( 'Gallery Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::GALLERY,
			]
		);
		
		$this->add_control(
			'home_banner_3_element_link',
			[
				'label' 		=> esc_html__( 'Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your url', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_3_element_small_img',
			[
				'label' 		=> esc_html__( 'Small Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'home_banner_3_element_small_img2',
			[
				'label' 		=> esc_html__( 'Small Image 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'home_banner_3_element_small_img3',
			[
				'label' 		=> esc_html__( 'Small Image 3', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->end_controls_section(); 
		
		$this->start_controls_section(
			'rating',
			[
				'label' => esc_html__( 'Rating', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_3_element_rating',
			[
				'label' 		=> esc_html__( 'Rating', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your rating', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '4.8', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_3_element_rating_text',
			[
				'label' 		=> esc_html__( 'Rating Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '12k+ ratings on google', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_3_element_star_rating',
			[
				'label' => esc_html__( 'Star Rating', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 5,
				'default' => 5,
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_3_element.php',$settings);
				echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handleTextChar();
					}					
				});
			 </script>
			";
		
	}
	
	protected function content_template() 
	{

    }
}