<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentBox5 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-5';
	}
	
	public function get_title() {
		return esc_html__('Content Box 5',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-posts-group';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_5_element_element_style',
			[
				'label' 	 => esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Style', DZ_TH_DOMAIN),
								'style_1'   => esc_html__('Style 1',DZ_TH_DOMAIN),
								'style_2'   => esc_html__('Style 2',DZ_TH_DOMAIN),
							
							),				
				'default'	 =>  'style_1',
			]
		);
		
		
		
		$this->add_control(
			'content_box_5_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Dental Implants', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'content_box_5_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'For more than 30 years, dental implants have enhanced the lives of countless individuals. These implants create a strong foundation for replacement teeth that mimic the appearance, feel, and functionality of natural teeth. As a result, patients can laugh, speak, and smile with renewed confidence.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_5_element_img',
			[
				'label' 		=> esc_html__( 'Image ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$this->add_control(
			'content_box_5_element_img2',
			[
				'label' 		=> esc_html__( 'Image 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$this->add_control(
			'content_box_5_element_img3',
			[
				'label' 		=> esc_html__( 'Image 3', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'content_box_5_element_element_style' => 'style_1',
				],
			]
		);
		$this->add_control(
			'content_box_5_element_img_gallary',
			[
				'label' 		=> esc_html__( 'Image Gallery', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::GALLERY,
				'condition' => [
					'content_box_5_element_element_style' => 'style_1',
				],
				
			]
		);
		$this->add_control(
			'contact_box_5_element_contact_us',
			[
				'label' => esc_html__( 'Contact Info', DZ_TH_DOMAIN),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
				
			]
		);
		
		$this->add_control(
			'contact_box_5_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'Appointment', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'contact_box_5_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'contact_box_5_element_image_align',
			[
				'label' => esc_html__( 'Image Position', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', DZ_TH_DOMAIN ),
						'icon' => 'eicon-text-align-left',
					],
					
					'right' => [
						'title' => esc_html__( 'Right', DZ_TH_DOMAIN ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'condition' => [
					'content_box_5_element_element_style' => 'style_2',
				],
				'default' => 'left',
				'toggle' => true,
				
			]
		);
		
		$this->add_control(
			'content_box_5_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner-2',
				'condition' => [
					'content_box_5_element_element_style' => 'style_2',
				],
			]
		);
		
		
		$this->end_controls_section();
		
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_5_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}