<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentbox1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-1';
	}
	
	public function get_title() {
		return esc_html__('Content Box 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-posts-group';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Sub Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your sub title', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( '', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_1_element_icon_img',
			[
				'label' 		=> esc_html__( 'Sub Icon Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			
			]
		);
		
		
		$this->add_control(
			'content_box_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'       => esc_html__( 'Inspirational Health', DZ_TH_DOMAIN ).'<br>'. esc_html__( 'Our Vision and Mission', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'content_box_1_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'       => esc_html__( 'To enhance the health and well-being of our community by providing compassionate, high-quality healthcare services through dedicated professionals and advanced medical practices.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_1_element_img',
			[
				'label' 		=> esc_html__( 'Image Upload', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'content_box_1_element_position',
			[
				'label' 		=> esc_html__( 'Image Position', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', DZ_TH_DOMAIN ),
						'icon' => 'eicon-text-align-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', DZ_TH_DOMAIN ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'right',
			]
		);
		
		$this->end_controls_section();
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'content_box_1_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Mission', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'content_box_1_element_item_description',
			[
				'label' 	=> esc_html__( 'Description', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'default' => esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal.', DZ_TH_DOMAIN ),
				
			]
		);
		$repeater->add_control(
			'content_box_1_element_item_icon',
			[
				'label' 	=> esc_html__( 'Icon', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::ICONS,	
			]
		); 
		
		
		
		
		$this->add_control(
			'content_box_1_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						
						'content_box_1_element_item_title' 		=> esc_html__( 'Mission', DZ_TH_DOMAIN ),
						'content_box_1_element_item_description' 	=> esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal.', DZ_TH_DOMAIN ),
					],
					[
						
						'content_box_1_element_item_title' 		=> esc_html__( 'Vision', DZ_TH_DOMAIN ),
						'content_box_1_element_item_description' 	=> esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal.', DZ_TH_DOMAIN ),
					],
					[
						
						'content_box_1_element_item_title' 		=> esc_html__( 'Values', DZ_TH_DOMAIN ),
						'content_box_1_element_item_description' 	=> esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal.', DZ_TH_DOMAIN ),
					],
				],
			]
		);
		
		$this->end_controls_section();
	
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'content_box_1_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_1_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}