<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZAwardsSlider1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-awards-slider-1';
	}
	
	public function get_title() {
		return esc_html__('Awards Slider 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-testimonial-carousel';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'awards_slider_1_element_subtitle',
			[
				'label' 		=> esc_html__( 'Sub Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your sub title', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'Achievements', DZ_TH_DOMAIN ),
				
			]
		);
		$this->add_control(
			'awards_slider_1_element_icon_img',
			[
				'label' 		=> esc_html__( 'Sub Icon Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		
		$this->add_control(
			'awards_slider_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'Awards', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'awards_slider_1_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'	 =>  esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'awards_slider_1_element_item_title',
			[
				'label' 		=> esc_html__( 'Gift Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'ClinicMaster 2024', DZ_TH_DOMAIN ),
			]
		);
		
		
		$repeater->add_control(
			'awards_slider_1_element_item_description',
			[
				'label' 	=> esc_html__( 'Gift Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Quality and Accreditation Institute', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'awards_slider_1_element_item_img',
			[
				'label' 		=> esc_html__( 'Gift Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$repeater->add_control(
			'awards_slider_1_element_item_text',
			[
				'label' 		=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Save the Childern', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'awards_slider_1_element_item_text_link',
			[
				'label' 		=> esc_html__( 'Text Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
				'default'   => 'https://clinicmaster.wprdx.com/medical/appointment',
			]
		);
		
		
		$this->add_control(
			'awards_slider_1_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				/* 'item_actions' => [
					'add'       => false,
					'duplicate' => false,
					'remove'    => false,
					'sort'      => true,
				], */
				'default' 		=> [
					[	
						'awards_slider_1_element_item_title' 	=> esc_html__( 'ClinicMaster 2024', DZ_TH_DOMAIN ),
						'awards_slider_1_element_item_description' 	=> esc_html__( 'Quality and Accreditation Institute', DZ_TH_DOMAIN ),
						'awards_slider_1_element_item_text' 	=> esc_html__( 'Save the Childern', DZ_TH_DOMAIN ),
						'awards_slider_1_element_item_text_link' 	=> 'https://clinicmaster.wprdx.com/medical/appointment',
						
					],	
					[	
						'awards_slider_1_element_item_title' 	=> esc_html__( 'ClinicMaster 2024', DZ_TH_DOMAIN ),
						'awards_slider_1_element_item_description' 	=> esc_html__( 'Quality and Accreditation Institute', DZ_TH_DOMAIN ),
						'awards_slider_1_element_item_text' 	=> esc_html__( 'Save the Childern', DZ_TH_DOMAIN ),
						'awards_slider_1_element_item_text_link' 	=> 'https://clinicmaster.wprdx.com/medical/appointment',
						
					],	
					[	
						'awards_slider_1_element_item_title' 	=> esc_html__( 'ClinicMaster 2024', DZ_TH_DOMAIN ),
						'awards_slider_1_element_item_description' 	=> esc_html__( 'Quality and Accreditation Institute', DZ_TH_DOMAIN ),
						'awards_slider_1_element_item_text' 	=> esc_html__( 'Save the Childern', DZ_TH_DOMAIN ),
						'awards_slider_1_element_item_text_link' 	=> 'https://clinicmaster.wprdx.com/medical/appointment',
						
					],	
					
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'awards_slider_1_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
			]
		);
		$this->end_controls_section();
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/awards_slider_1_element.php',$settings);
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handleAwardSlider();
					}					
				});
			 </script>
			";
		
	}
	
	protected function content_template() 
	{

    }
}