<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZAppointmentForm3 extends Widget_Base 
{
	public function get_name() {
		return 'dz-appointment-form-3';
	}
	
	public function get_title() {
		return esc_html__('Appointment Form 3',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-form-horizontal';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'appointment_form_3_element_title',
			[
				'label' 		=> esc_html__( 'Form Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 	=> esc_html__( ' ', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'appointment_form_3_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			
			]
		);
		
	
		
		$this->add_control(
		'appointment_form_3_element_contact_form',
			[
				'label' 	 => esc_html__( 'Contact Form', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_contact_form_list(),
				'default'	 => '',
			]
		);
		$this->add_control(
			'appointment_form_3_element_counter_number',
			[
				'label' 		=> esc_html__( 'Counter Number', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your number', DZ_TH_DOMAIN ),
				'default' 	=> '20',
			]
		);
		$this->add_control(
			'appointment_form_3_element_symbol',
			[
				'label' 		=> esc_html__( 'Symble', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'default' 	=> '+',
			]
		);
		$this->add_control(
			'appointment_form_3_element_counter_text',
			[
				'label' 		=> esc_html__( 'Counter Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your number', DZ_TH_DOMAIN ),
				'default' 	=> 'Years <br> Experienced',
			]
		);
		
		$this->add_control(
			'appointment_form_3_element_item_title',
			[
				'label' 		=> esc_html__( 'Gift Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'ClinicMaster 2024', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'appointment_form_3_element_item_description',
			[
				'label' 	=> esc_html__( 'Gift Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Quality and Accreditation Institute', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'appointment_form_3_element_item_img',
			[
				'label' 		=> esc_html__( 'Gift Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				
			]
		);
		$this->add_control(
			'appointment_form_3_element_item_text',
			[
				'label' 		=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   	=> esc_html__( 'Save the Childern', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'appointment_form_3_element_item_text_link',
			[
				'label' 		=> esc_html__( 'Text Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
				'default'   => 'https://clinicmaster.wprdx.com/medical/appointment',
			]
		);
		
		
		$this->add_control(
			'appointment_form_3_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
				
			]
		);
		
		$this->end_controls_section();
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/appointment_form_3_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}