<?php
/**
 * Custom post types register.
 * @since   1.0
 * @author DexignZone
 *
 */



class DZSeo {
	
	
	public $seo_theme_option, $args =  [];
	
    /**
     * Constructor
     *
     * @access private
     */
    function __construct() {
		add_action( 'wp_head', array( $this, 'dz_wpseo_head' ), 1 );
    }
   
	
	function dz_wpseo_head(){
		
		$this->seo_theme_option = $this->dz_seo_social_meta_options();
		$this->dz_seo_social_meta_tags();
	}
	
	function dz_seo_social_meta_tags(){
		$meta_html = '';
		if(!empty($this->seo_theme_option)){
			foreach($this->seo_theme_option as $key => $value){
				if(!empty($value['value']) && preg_match('/image/i',$value['value'])){
					if(!empty($value['content']['url'])){
						$value['content'] = $value['content']['url'];	
					}
				}  
			$meta_html .= ' <meta '.$value['label'].'="'.$value['value'].'" content="'.$value['content'].'">'." \r\n";
			}
		}
		echo $meta_html;
	}
	
	function dz_seo_social_meta_options(){
		if(function_exists('get_seo_meta_value_args')){
			return get_seo_meta_value_args();
		}else{
			return false;
		}
	}
	
	
}
new DZSeo();